<?php
require_once('../app.php');

global $conn;

if (isset($_POST['register'])) {
    //getting user inputs

    $first_name = sanitize($_POST['first_name']);
    $last_name = sanitize($_POST['last_name']);
    $email = sanitize($_POST['email']);
    $phone = sanitize($_POST['phone']);
    $gender = sanitize($_POST['gender']);
    $country = sanitize($_POST['country']);
    $state = sanitize($_POST['state']);
    $address = sanitize($_POST['address']);
    $postcode = sanitize($_POST['postcode']);
    $account = sanitize($_POST['account']);
    $currency = sanitize($_POST['currency']);
    $password = sanitize($_POST['password']);
    $conf_pass = sanitize($_POST['conf_pass']);
    $passport = $_FILES["passport"];

    $data = ['First Name' => $first_name, 'Last Name' => $last_name, 'Email Address' => $email, 'Phone Number' => $phone, 'Gender' => $gender, 'Country' => $country, 'State' => $state, 'Full Address' => $address, 'Postcode' => $postcode, 'Account Type' => $account, 'Currency' => $currency, 'Password' => $password, 'Confirm Password' => $conf_pass, 'Passport' => $passport];

    $error = emptyField($data);
    if (!empty($error)) {
       $_SESSION['msg'] = alert($icon='error',$title='Oops...',$text=$error);
        redirect('userarea');
    }
    


    $error = "Password and Confirm Password those not match";
    if (!password_match($data['Password'], $data['Confirm Password'])) {
        $_SESSION['msg'] = alert($icon='error',$title='Oops...',$text=$error);
        redirect('userarea');
    }

    $error = "Email Address is not valid";
    if (!validEmail($data['Email Address'])) {
        $_SESSION['msg'] = alert($icon='error',$title='Oops...',$text=$error);
        redirect('userarea');
    }

    $passport_saver = img_saver($passport, $img_name='Passport');
    

    $user = validUser($first_name, $last_name, $email,$conn);
    $error = 'Account already exists';
    if (!empty($user)) {
        $_SESSION['msg'] = alert($icon='error',$title='Oops...',$text=$error);
        redirect('userarea');
    }

    $securepassword = passwordHash($data['Password']);

    $success = "Registeration Successful, go to login!!!";
    if (addUserToDatabase($params = [$data['First Name'],$data['Last Name'],$data['Email Address'],$data['Phone Number'],$data['Gender'],$data['Country'],$data['State'],$data['Full Address'],$data['Postcode'],$data['Account Type'],$data['Currency'],$securepassword,$passport_saver], $conn)) {
        welcome_mail($email,$last_name, $first_name);
        $success = 'Account Created Successfully';
        $_SESSION['msg'] = alert($icon='success',$title=$success,$text='Please go to your email and comfirm your email to activate your account, An activation email has been sent to your email');
        redirect('userarea');
    }
}
